/******************************************************************************
 * Technical University of Technology Darmstadt
 * Industrial Process and System Communication
 * Project:  TCP
 * Filename: TCPCloseWait.java
 * Author:   Gunter Weiss
 * Contents: Actions in State CLOSE_WAIT of TCP-FSM
 * Last Changes: Gunter Weiss 23/5/97
 *****************************************************************************/
import java.util.Vector;
import java.util.Date;

/******************************************************************************
* Class: TCPEstablished
* Description: acts corresponding the properties of incoming TCP-Segment
******************************************************************************/
public class TCPCloseWait {

SegArrive parent;
SessionControlBlock newtcb;
int j;

public SessionControlBlock TCPCloseWait( SegArrive home, SessionControlBlock newtcb, int j) {

    this .parent = home;
    this .newtcb = newtcb;
    this .j = j;

    while(true) {
          if(parent.segment1.Seqnumb == newtcb.RCVNXT) {
    	      if(parent.segment1.ACK == 1) {
               	newtcb. setack.setAck();
               	parent. tcppro.darfsenden.getrighttosend();
                newtcb.SNDNXT = parent.segment1.Acknumb;
                newtcb.RCVNXT = parent.segment1.Seqnumb +1;
                newtcb.RCVWND = parent.segment1.Wsize;
	        newtcb.acktime = new Date().getTime();
                parent. fromnet.removeElementAt(0);
                parent. tcppro.darfsenden.giverighttosend();
                break;
              }
              if(parent.segment1.RST==1) {
                //System.out.println("Server genau segment mit rst = 1");
                newtcb.partnerresp = -1;
                newtcb.TcpStatus = 0;
                newtcb. retqueue.removeAllElements();
                parent. fromnet.removeElementAt(0);
	            parent.tcppro.cid--;
                parent. tcb.removeElementAt(j);
                break;
              }
              if(parent.segment1.SYN ==1) {
                parent. fromnet.removeElementAt(0);
                newtcb.TcpStatus = 0;
                parent. tcb.removeElementAt(j);
		        parent.tcppro.cid--;
                break;
              }
          }
          parent. fromnet.removeElementAt(0);
    } //END while(true)
    return newtcb;
} //END methode TCPCloseWait
} //END class TCPCloseWait
